
<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.13/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.2.4/css/buttons.dataTables.min.css">
<style>
    table.dataTable tbody td {
        word-break: break-word;
        vertical-align: top;
    }
.required:after {
        content: "*";
        color: red;
    }
    .error{
        color:red;
    }
</style>
<div class="app-content content">
    <div class="content-wrapper">
        <br>
        <?php echo $__env->make('alert.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Technology List</h4>
                        <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                        <div class="heading-elements">
                            <ul class="list-inline mb-0">
                                <li><a data-toggle="modal" data-target="#createTechnologyModal"  href="#" class="btn btn-success mr-1 mb-1 ladda-button" data-style="expand-left"><i class="ft-plus white"></i> <span class="ladda-label">Add Technology</span></a></li>
                                <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-content collapse show">
                        <div class="card-body card-dashboard">
                            <table class="table table-striped table-bordered dom-jQuery-events dataTable" id="DataTables" role="grid" aria-describedby="DataTables_Table_0_info">
                                <thead>
                                    <tr role="row">
                                        <th>Technology</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $technologys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $technology): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr role="row" data-toggle="modal" data-target="#technologyDetailModal" class="odd" data-id="<?php echo e($technology->id); ?>">
                                        <td><?php echo e($technology->name); ?></td>
                                        <td><h4 <?php if($technology->status==1): ?> class="danger text-center" <?php else: ?> class="success text-center" <?php endif; ?>><?php echo e(($technology->status==1)?"Inactive":"Active"); ?></h4></td>
                                        <td>
                                            <a class="btn btn-primary text-white tab-order" data-toggle="modal" data-target="#editTechnologyModal<?php echo e($technology->id); ?>"  href="#"><i class="icon-pencil"></i> Edit</a>
                                            <button <?php if($technology->status==0): ?> class="btn btn-danger text-white tab-order" <?php else: ?> class="btn btn-success text-white tab-order" <?php endif; ?> onclick="confirmDelete('technology-active-<?php echo e($technology->id); ?>','<?php echo e($technology->name); ?>','<?php echo e($technology->status); ?>');"> <?php if($technology->status==0): ?> <i class="fa fa-thumbs-o-down"></i> Inactive <?php else: ?> <i class="fa fa-thumbs-o-up"></i> Active <?php endif; ?></button>
                                            <form id="technology-active-<?php echo e($technology->id); ?>" action="<?php echo e(url('admin/active/technology/')); ?>/<?php echo e($technology->id); ?>" method="get">
                                                <?php echo e(csrf_field()); ?>

                                            </form>
                                        </td>
                                    </tr>
                                    <div class="modal fade text-left show" id="editTechnologyModal<?php echo e($technology->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel35" style="padding-right: 17px;">
                                        <div class="modal-dialog" role="document">
                                          <div class="modal-content">
                                            <div class="modal-header">
                                              <h3 class="modal-title" id="myModalLabel35"> Edit Technology</h3>
                                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                              </button>
                                            </div>
                                            <form method="POST" action="<?php echo e(url('admin/edit/Redington/technology')); ?>/<?php echo e($technology->id); ?>">
                                                <?php echo csrf_field(); ?>
                                              <div class="modal-body">
                                                    <fieldset class="form-group floating-label-form-group">
                                                      <label for="email" class="label-control required">Technology</label>
                                                      <input type="text" class="form-control" id="editname" name="editname" value="<?php echo e($technology->name); ?>">
                                                        <?php if($errors->has('editname')): ?>
                                                            <span class="help-block">
                                                                <strong class="error"><?php echo e($errors->first('editname')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                    </fieldset>
                                                    <br>
                                                  <fieldset class="form-group floating-label-form-group">
                                                      <label for="title1" class="label-control required">Description</label>
                                                      <textarea class="form-control detail2" id="editdescription<?php echo e($technology->id); ?>" name="editdescription"><?php echo $technology->description; ?></textarea>
                                                        <?php if($errors->has('editdescription')): ?>
                                                            <span class="help-block">
                                                                <strong class="error"><?php echo e($errors->first('editdescription')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                  </fieldset>
                                              </div>
                                              <div class="modal-footer">
                                                  <input type="reset" class="btn btn-outline-secondary btn-lg" data-dismiss="modal" value="close">
                                                  <input type="submit" class="btn btn-outline-primary btn-lg" value="Update">
                                              </div>
                                            </form>
                                          </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <div class="pull-right">
                                <?php echo $technologys->render(); ?>

                            </div>
                        </div>
                    </div>

                    <div class="modal fade text-left show" id="createTechnologyModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel35" style="padding-right: 17px;">
                        <div class="modal-dialog" role="document">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h3 class="modal-title" id="myModalLabel35"> Create Technology</h3>
                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                              </button>
                            </div>
                            <form method="POST" action="<?php echo e(url('admin/add/new/Redington/technology')); ?>">
                                <?php echo csrf_field(); ?>
                              <div class="modal-body">
                                  <fieldset class="form-group floating-label-form-group">
                                      <label for="email" class="label-control required">Technology</label>
                                      <input type="text" class="form-control" id="techname" name="techname" placeholder="Technology Name">
                                        <?php if($errors->has('techname')): ?>
                                            <span class="help-block">
                                                <strong class="error"><?php echo e($errors->first('techname')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                  </fieldset>
                                  <br>
                                  <fieldset class="form-group floating-label-form-group">
                                      <label for="title1" class="label-control required">Description</label>
                                      <textarea class="form-control" id="techdescription" name="techdescription" placeholder="Technology Description"></textarea>
                                        <?php if($errors->has('techdescription')): ?>
                                            <span class="help-block">
                                                <strong class="error"><?php echo e($errors->first('techdescription')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                  </fieldset>
                              </div>
                              <div class="modal-footer">
                                  <input type="reset" class="btn btn-outline-secondary btn-lg" data-dismiss="modal" value="close">
                                  <input type="submit" class="btn btn-outline-primary btn-lg" value="Save">
                              </div>
                            </form>
                          </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Import jQuery before export.js-->
<script type="text/javascript" src="https://code.jquery.com/jquery-2.1.1.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard-all/ckeditor.js"></script>

<!--Data Table-->
<script type="text/javascript"  src=" https://cdn.datatables.net/1.10.13/js/jquery.dataTables.min.js"></script>
<script type="text/javascript"  src=" https://cdn.datatables.net/buttons/1.2.4/js/dataTables.buttons.min.js"></script>

<!--Export table buttons-->
<script type="text/javascript"  src="https://cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js"></script>
<script type="text/javascript" src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.24/build/pdfmake.min.js" ></script>
<script type="text/javascript"  src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.24/build/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.2.4/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.2.1/js/buttons.print.min.js"></script>
<script>
    CKEDITOR.replace( 'techdescription' );
    // CKEDITOR.replace( 'detail2' );
    $('.detail2').each(function () {
        CKEDITOR.replace($(this).prop('id'));
    });
    function confirmDelete(id,name) {
        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you want to remove this user '+name+'?',
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: `Ok`,
            cancelButtonText: `Cancel`,
        }).then((result) => {
            if (result.isConfirmed) {
                $('#'+id).submit();
            } 
        })
    }
</script>
<script type="text/javascript">
    $(document).ready(function() {
        $.noConflict();
        
        // $('#DataTables').DataTable({
        //     "ordering": false,
        //     "info": true,
        //     "autoWidth": false,
        //     "bInfo": false,
        //     "paging": true,
        //     "lengthMenu": [[25, 50, -1], [25, 50, "All"]],
        //     "dom": "Bfrtip",
        //     "buttons": [
        //         {
        //         extend: "copy",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "csv",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "excel",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "print",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "pdf",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //     ],
        // }),
        // $(
        // ".buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel"
        // ).removeClass("dt-button buttons-html5").addClass("btn btn-info square  mr-1 mb-1");
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\CodeaTech\Project\Redington\resources\views/admin/technology/list.blade.php ENDPATH**/ ?>