<?php



namespace App\Http\Controllers\Api;



use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\User;

use App\Models\UserSpec;

use Illuminate\Support\Facades\Validator;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Password;

class AuthController extends Controller

{

    public function login(Request $request){

        $validator = Validator::make($request->all(), [

            'phone' => 'required',

            'password' => 'required'

        ]);

        if($validator->fails()){

            $response['status']  = 'error';

            $response['message'] = $validator->messages()->first();

        }else{

            $credentials = $request->only('phone', 'password');

            if(Auth::attempt($credentials)){

                if(Auth::user()->login_status==0){
                    $response['status']  = 'success';

                    $response['message'] = 'Logged in successfuly';

                    $response['token']   = Auth::user()->api_token;

                    $response['type'] = Auth::user()->type;

                    $response['user_id'] = Auth::user()->id;
                    User::where('id', Auth::user()->id)->update(['login_status' => 1]);
                    
                }else{
                    $response['status']  = 'error';

                    $response['message'] = 'Already logged-in on another device';
                }
            }else{

                $response['status']  = 'error';

                $response['message'] = 'Invalid credentials';

            }

        }

        return response()->json($response);

    }



    public function register(Request $request){

        $validator = $this->createValidation($request);

        if ($validator->fails()) {

            $response['status']  = 'error';

            $response['message'] = $validator->messages()->first();

        }else{

            DB::beginTransaction();

            $fileName = "";

            if ($request->file('image') != "") {

                $file = $request->file('image');

                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();

                $file->move('uploads/profiles/', $fileName);

                $fileName = 'uploads/profiles/' . $fileName;

            }

            $userId = User::insertGetId([

                'name' => $request->name,

                'email' => $request->email,

                'phone' => $request->phoneNumber,

                'type'=>$request->type,

                'status'=>0,

                'verify_status'=>1,

                'image'=>$fileName,

                'password' => Hash::make($request->password),

                'company'=> $request->company,

                'post'=> $request->post,

                'linkedin' => $request->linkedin,

                'poc_id'=>($request->type==4)?$request->poc:NULL,

                'api_token'=>Str::random(60),

                "created_at" =>  \Carbon\Carbon::now(), # new \Datetime()

                "updated_at" => \Carbon\Carbon::now(),  # new \Datetime()



            ]);

            

            

            DB::commit();

            $user   = User::find($userId);

            $usertype = (

                ($request->type == 2) ? "Customer" :

                (($request->type == 3) ? "Partner" :

                (($request->type == 4) ? "Employee" : "User"))

                );
                

                $response['status']  = 'success';

                $response['message'] = $usertype.' created successfuly';

                $response['type'] = $user->type;

                $response['user_id'] = $user->id;

                $response['token']   = $user->api_token;

        }

        return response()->json($response);

    }



    public function createValidation($request)

    {

        if($request->type==4){
            $validator = Validator::make($request->all(),

            [

                'name' => 'required',

                'phoneNumber' => 'required|unique:users,phone',

                'email' => 'required|email|max:255|regex:/(.*)@redington\.com/i|unique:users,email',

                'poc' => 'required',
                 
                'password' => 'required',

                'type' => 'required'

            ],[

                'name.required' => 'Please enter name',

                'phoneNumber.required' => 'Please enter phone number',

                'email.required' => 'Please enter email',

                'email.regex' => 'Domain not valid for registration(example@redington.com).',

                'poc.required' => 'Please select POC',
                'password.required'=>'Please enter password',
                'type.required'=>'Please enter type'

            ]);

        }elseif($request->type==3){

            $validator = Validator::make($request->all(),

            [

                'name' => 'required',

                'phoneNumber' => 'required|unique:users,phone',

                'email' => 'required|email|max:255|unique:users,email',
                'password' => 'required',
                'type' =>'required'

            ],[

                'name.required' => 'Please enter name',

                'phoneNumber.required' => 'Please enter phone number',

                'email.required' => 'Please enter email',

                'password.required' => 'Please enter password',
                'type.required'=>'Please enter type'

            ]);

        }else{

            $validator = Validator::make($request->all(),

            [

                'name' => 'required',

                'phoneNumber' => 'required|unique:users,phone',

                'email' => 'required|email|max:255|unique:users,email',

                'password' => 'required',

                'type' => 'required'

            ],[

                'name.required' => 'Please enter name',

                'phoneNumber.required' => 'Please enter phone number',

                'email.required' => 'Please enter email address',
                'password.required' => 'Please enter password',
                'type.required'=>'Please enter user type'

            ]);

        }

        return $validator;

    }

    public function logout(Request $request){
        $user   = User::find($request->user_id);
        $user->api_token = Str::random(60);
        $user->login_status = 0;
        $user->save();
        $response['status']  = 'success';
        $response['message'] = 'Logout successfuly';
        return response()->json($response);
    }

    public function otp(Request $request){
        $params=[
            "api_id" => 'API43404236', 
            "api_password" => 'password@123', 
            "sms_type" => 'T', 
            "encoding" => 'T', 
            "sender_id" => 'tstala', 
            "phonenumber" => '919995179134', 
            "templateid" => null, 
            "textmessage" => "Test OTP Message"
        ];
        $url    = 'http://api.smsala.com/api/SendSMS';
        $header = [
			'Content-Type: application/json',
			'Cache-Control: no-cache'
			];
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
		$response = curl_exec($ch);
		curl_close ($ch);
		return $response;
    }

    public function changePassword(Request $request){
        $credentials = $request->only('id', 'password');
        if(Auth::attempt($credentials)){
            User::where('id', $request->id)->update([
                'password' => Hash::make($request->new_password),
                'api_token'=> Str::random(60) 
            ]);
            $response['status']  = 'Success';
            $response['message'] = 'Password changed successfuly';
        }else{
            $response['status']  = 'Error';
            $response['message'] = 'Incorrect password';
        }
        return response()->json($response);
    }

    public function addInterest(Request $request){
        $feature = UserSpec::updateOrInsert([

            'user_id' => $request->user_id],[

            'service_id' => isset($request->services)?implode(",",$request->services):null,

            'technology_id' => isset($request->technologies)?implode(",",$request->technologies):null,

            "created_at" =>  \Carbon\Carbon::now(), # new \Datetime()

            "updated_at" => \Carbon\Carbon::now()  # new \Datetime()
        ]);

            $response['status']  = 'Success';
            $response['message'] = 'Interests added successfuly';

            return $response;
    }

    public function notificationStatus(Request $request){
        User::where('id', $request->user_id)->update(['notifi_status' => $request->status]);
        $response['status'] = 'Success';
        $response['data']   = 'Notification status changed';
        return $response;
    }

    public function getNotificationStatus(Request $request){
        $userData=User::where('id', $request->user_id)->first();
        $response['status'] = 'Success';
        $response['data']   = $userData->notifi_status;
        return $response;
    }

}

