<?php



namespace App\Http\Controllers\Api;



use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\User;

use App\Models\Service;

use App\Models\Technology;

use App\Models\Resource;

use App\Models\SubResource;

use App\Models\Journal;

use App\Models\ValueJournal;

use App\Models\ValueStory;

use App\Models\Brand;

use App\Models\Region;

use App\Models\SalesConnect;

use App\Models\PresetQuestion;

use App\Models\Product;

use App\Models\MainService;

use App\Models\Events;

use Illuminate\Support\Facades\Validator;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\DB;

use App\Models\Notification;

use App\Models\Requests;

use App\Models\EventRegister;
use App\Models\History;

class UserApiController extends Controller

{

    public function api_validation($request){

        $tokenget = $request->header('Authorization');

        //return $tokenget;

        if(strpos($tokenget,' ') > -1)

            list($b,$t) = @explode(' ',$tokenget);

        else

            $b = $tokenget;



        if($b != '' && $b != "Bearer"){

            $data['response'] = "Token error!!";

            $data['status'] = "Error";

            //return response()->json($data);

            return 0;

        }



        $token = str_replace("Bearer ", "", $tokenget);

        $valid = $this->validateInternalToken($token,$request->user_id);

        return  $valid;

    }



    public function validateInternalToken($token,$userId){

        // $actualToken = config('constants.TOKEN');

        $user = User::where('api_token',$token)->exists();

        if($user){

            return 1;

        }else{

            return 0;

        }  

    }



    public function operation_validation($request){

        if(!isset($request['op'])){

            return "Error";

        }

        else{

            return $request['op'];

        }



    }

    public function getProfile(Request $request,$user_id){
        $valid = $this->api_validation($request);

        if($valid != 1){

            $data['response'] = 'Invalid Token';

            $data['status'] = "Error";

            return response()->json($data);

        }
        $userData   = User::with('userSpec')->where('id',$user_id)->first();
        if($userData){
            return $userData;
        }else{
            $userData['response'] = 'User not found';
            $userData['status'] = "Error";
            return $userData;
        }
    }



    public function serviceList(Request $request){

        $serviceData = Service::where('status',0)->get();

        return $serviceData;

    }



    public function technologyList(Request $request){

        $technologyData = Technology::where('status',0)->get();

        return $technologyData;

    }



    public function resourceList(Request $request){

        $resourceData = Resource::where('status',0)->whereJsonContains('type', 2)->get();
        $response['data']=$resourceData;
        return $response;

    }



    public function subresourceList($id){

        $subresourceData = SubResource::where('resource_id',$id)->where('status',0)->get();

        return $subresourceData;

    }



    public function journalList(){

        $journalData = Journal::where('status',0)->get();

        $response['status'] = 'Success';
        $response['data']   =$journalData;
        return $response;

    }



    public function subJournals($id){

        $subJournalData = ValueJournal::where('journal_id',$id)->where('status',0)->get();

        $response['status'] = 'Success';
        $response['data']   =$subJournalData;
        return $response;

    }

    

    public function valuestories(){

        $storyData = ValueStory::where('status',0)->get();

        $response['status'] = 'Success';
        $response['data']   =$storyData;
        return $response;

    }



    public function brands(){

        $brandData = Brand::where('status',0)->get();

        return $brandData;

    }



    public function regions(){

        $regionData = Region::where('status',0)->get();

        return $regionData;

    }



    public function salesconnectList(){

        $salesData = SalesConnect::where('status',0)->get();

        return $salesData;

    }

    public function presetQuestions(){
        $QuestionData = PresetQuestion::where('status',0)->get();
        return $QuestionData;
    }

    public function products(){
        $productData = Product::where('status',0)->get();
        return $productData;
    }

    public function mainserviceList(Request $request){
        $serviceData = MainService::where('status',0)->get();
        $response['data']= $serviceData;
        return $response;
    }

    public function neweventsList(Request $request){
        $now_str = \Carbon\Carbon::now();
        $eventData = Events::where('date_time', '>=', $now_str)->where('status',0)->get();
        $response['status'] = 'Success';
        $response['data']   =$eventData;
        return $response;
    }
    public function pasteventsList(Request $request){
        $now_str = \Carbon\Carbon::now();
        $eventData = Events::where('date_time', '<', $now_str)->where('status',0)->get();
        $response['status'] = 'Success';
        $response['data']   =$eventData;
        return $response;
    }

    public function getRequests($userid){
        $requestData = Requests::where('from_id',$userid)->with('subservice','business')->get();
        $response['status'] = 'Success';
        $response['data']= $requestData;
        return $response;
    }

    public function getschedules($userid){
        $salesData = SalesConnect::where('from_id',$userid)->get();
        $response['status'] = 'Success';
        $response['data']= $salesData;
        return $response;
    }

    public function myevents(Request $request){
        $eventData = EventRegister::where('user_id',$request->userid)->get();
        $response['status'] = 'Success';
        $response['data']= $eventData;
        return $response;
    }

    public function myhistory(Request $request){
        $historyData = History::where('from',$request->userid)->get();
        $response['status'] = 'Success';
        $response['data']= $historyData;
        return $response;
    }

    public function newrequest(Request $request){
        $requestId = Requests::insertGetId([
            'req_id' => $request->id,
            'from_id'=>$request->user_id,
            'type'=>$request->type, //Sub_service,Business_Solution,Sales_Connect
            "created_at" =>  \Carbon\Carbon::now(), # new \Datetime()
            "updated_at" => \Carbon\Carbon::now(),  # new \Datetime()
        ]);
        $admin = User::find(1);
        $user = User::find($request->user_id);
        if($request->type=="Sub_service"){
            $sub = SubService::find($request->id);
            $message = "Appoinment for ".$sub->name." is requested from ".$user->name;
        }elseif($request->type=="Business_Solution"){
            $business = BusinessSolution::find($request->id);
            $message = "Meeting schedule for ".$business->name." is requested from ".$user->name;
        }else{
            $sales = SalesConnect::find($request->id);
            $message = "A meeting requested from ".$user->name;
        }
        if(isset($requestId)){
            $notificationId = Notification::insertGetId([
                'req_from' => $requestId,
                'from_id'=>$request->user_id, //logged in user
                'to_id' => $admin->id,
                'type' => $request->type,
                'message' => $message,
                "created_at" =>  \Carbon\Carbon::now(), # new \Datetime()
                "updated_at" => \Carbon\Carbon::now(),  # new \Datetime()
    
            ]);
            Request::where('id',$requestId)->update(['notifid'=>$notificationId]);
            $response['status']     = 'Success';
            $response['data']       = 'Request Send';
            return $response;
        }else{
            $response['status']  = 'Error';
            $response['data'] = 'Some error occuired';
            return $response;
        }
    }

}

