<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/login','Api\AuthController@login');
Route::post('/register','Api\AuthController@register');
Route::get('/user/api_operations', 'Api\UserApiController@apiOperations');
Route::get('/profile/{user_id}','Api\UserApiController@getProfile');
Route::get('/services','Api\UserApiController@serviceList');
Route::get('/technology','Api\UserApiController@technologyList');
Route::get('/resources','Api\UserApiController@resourceList');
Route::get('/sub_resource/{id}','Api\UserApiController@subresourceList');
Route::get('/value_journals','Api\UserApiController@journalList');
Route::get('/sub_journals/{id}','Api\UserApiController@subJournals');
Route::get('/value_stories','Api\UserApiController@valuestories');
Route::get('/brands','Api\UserApiController@brands');
Route::get('/regions','Api\UserApiController@regions');
Route::get('/salesconnect','Api\UserApiController@salesconnectList');
Route::get('/presetQuestions','Api\UserApiController@presetQuestions');
Route::get('/products','Api\UserApiController@products');
Route::get('/main/services','Api\UserApiController@mainserviceList');
Route::get('new/events','Api\UserApiController@neweventsList');
Route::get('past/events','Api\UserApiController@pasteventsList');

Route::prefix('auth')->group(function () {
    Route::post('/login','Api\AuthController@login');
    Route::post('/register','Api\AuthController@register');
    Route::post('/logout','Api\AuthController@logout');
    Route::post('/otp','Api\AuthController@otp');
    Route::post('/changePassword','Api\AuthController@changePassword');
    Route::post('/addInterest','Api\AuthController@addInterest');
    Route::post('/notificationStatus','Api\AuthController@notificationStatus');
    Route::get('/getNotificationStatus','Api\AuthController@getNotificationStatus');
});

Route::prefix('user')->group(function (){
    Route::get('/profile/{id}','Api\UserApiController@getProfile');
    
});

Route::prefix('customer')->group(function () {
    Route::get('/services','Api\CustomerApiController@mainserviceList');
    Route::get('/resources','Api\CustomerApiController@resourceList');
    Route::get('/regions','Api\CustomerApiController@regions');
    Route::get('/brands','Api\CustomerApiController@brands');
    Route::get('/technology','Api\CustomerApiController@technologyList');
    Route::get('/businessSolutions','Api\CustomerApiController@businessSolutions');
    Route::get('/serviceList','Api\CustomerApiController@serviceList');
    Route::get('/pocList','Api\CustomerApiController@selectPoc');
    Route::get('/products','Api\CustomerApiController@products');
    Route::post('/connectnow','Api\CustomerApiController@connectnow');
    Route::post('/sendReply','Api\CustomerApiController@sendReply');
    Route::post('/scheduleMeeting','Api\CustomerApiController@scheduleMeeting');
    Route::post('/feedback','Api\CustomerApiController@feedback');
    Route::get('/help','Api\CustomerApiController@help');
    Route::get('/terms','Api\CustomerApiController@terms');
    Route::get('/value_journals','Api\CustomerApiController@journalList');
    Route::get('/value_stories','Api\CustomerApiController@valuestories');
    Route::get('/events','Api\CustomerApiController@eventsList');
    Route::get('/getRequests','Api\CustomerApiController@getRequests');
    Route::get('/myEvents','Api\CustomerApiController@myEvents');
    Route::get('/myHistory','Api\CustomerApiController@myhistory');
    Route::post('/newRequest','Api\CustomerApiController@newRequest');
    Route::get('/myNotifications','Api\CustomerApiController@myNotifications');
    Route::post('/readNotification','Api\CustomerApiController@readNotification');
});