<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.13/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.2.4/css/buttons.dataTables.min.css">
<style>
    table.dataTable tbody td {
        word-break: break-word;
        vertical-align: top;
    }
.required:after {
        content: "*";
        color: red;
    }
    .error{
        color:red;
    }
</style>
<div class="app-content content">
    <div class="content-wrapper">
        <br>
        <?php echo $__env->make('alert.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><a href="<?php echo e(url('admin/business_solutions')); ?>"><i class="fa fa-arrow-left"></i></a> &nbsp;&nbsp;Requests</h4>
                        <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                        <div class="heading-elements">
                            <ul class="list-inline mb-0">
                                
                                <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-content collapse show">
                        <div class="card-body card-dashboard">
                            <table class="table table-striped table-bordered dom-jQuery-events dataTable" id="DataTables" role="grid" aria-describedby="DataTables_Table_0_info">
                                <thead>
                                    <tr role="row">
                                        <th>From</th>
                                        <th>User Type</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr role="row" class="odd">
                                        <td><?php echo e($request->from->name); ?></td>
                                        <td><?php echo e($request->from->type==2?"Customer":$request->from->type==3?"Partner":"Employee"); ?></td>
                                        <td><h4 <?php if($request->status==0): ?> class="warning" <?php elseif($request->status==1): ?> class="success" <?php else: ?> class="danger"  <?php endif; ?>><?php if($request->status==0): ?> Waiting <?php elseif($request->status==1): ?>  Accepted <?php else: ?> Rejected  <?php endif; ?></h4></td>
                                        <td>
                                            <a class="btn btn-primary text-white tab-order" data-toggle="modal" data-target="#viewModal<?php echo e($request->id); ?>"  href="#"><i class="icon-eye"></i> View</a>
                                            
                                        </td>
                                    </tr>
                                    <div class="modal" id="viewModal<?php echo e($request->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel35" style="padding-right: 17px;">
                                        <div class="modal-dialog" role="document">
                                          <div class="modal-content">
                                            <div class="modal-header">
                                              <h3 class="modal-title" id="myModalLabel35"> View Request Details</h3>
                                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                              </button>
                                            </div>
                                            <form method="post" action="<?php echo e(url('admin/respond/request')); ?>/<?php echo e($request->id); ?>">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="type" value="Business_Solution">
                                                <div class="modal-body">
                                                    <p class="text-success text-center" id="showme" style="display:block;"><strong><?php if($request->status==1): ?> Request Granted <?php elseif($request->status==2): ?> Request Rejected!! <?php else: ?> Your request in progress <?php endif; ?></strong></p>
                                                    <p class="text-info text-center" id="notif_message" style="display:none;"><strong><?php if(isset($request->notifi)): ?><?php echo e($request->notifi->message); ?> <?php else: ?> <?php endif; ?></strong></p>
                                                    <fieldset class="input-group floating-label-form-group">
                                                        <label class="label-control col-md-4"><b>Business Solution Name</b>:</label>
                                                        <input  type="text" class="form-control col-md-8" value="<?php echo e((isset($request->business))?$request->business->name:""); ?>">
                                                    </fieldset><br>
                                                    <fieldset class="input-group floating-label-form-group">
                                                        <label class="label-control col-md-4"><b>Request From</b>:</label>
                                                        <input  type="text" class="form-control col-md-8" value="<?php echo e((isset($request->from))?$request->from->name:""); ?>">
                                                    </fieldset><br>
                                                    <fieldset class="input-group floating-label-form-group">
                                                        <label class="label-control col-md-4"><b>Requested Date</b>:</label>
                                                        <input  type="text" class="form-control col-md-8" value="<?php echo e(Carbon\Carbon::parse($request->date_time)->format('j F Y h:i A')); ?>">
                                                    </fieldset><br>
                                                    <fieldset class="input-group floating-label-form-group">
                                                        <label class="label-control col-md-4"><b>Status</b>:</label>
                                                        <select class="form-control col-md-8" name="status">
                                                                <option value="1" <?php if($request->status==1): ?> selected <?php endif; ?>>Accept</option>
                                                                <option value="2" <?php if($request->status==2): ?> selected <?php endif; ?>>Reject</option>
                                                        </select>
                                                    </fieldset><br>
                                                    
                                                </div>
                                                <div class="modal-footer">
                                                    <input type="reset" class="btn btn-outline-secondary btn-lg" data-dismiss="modal" value="close">
                                                    <input type="submit" class="btn btn-outline-primary btn-lg" value="Save">
                                                </div>
                                            </form>
                                          </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <div class="pull-right">
                                <?php echo $list->render(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Import jQuery before export.js-->
<script type="text/javascript" src="https://code.jquery.com/jquery-2.1.1.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard-all/ckeditor.js"></script>

<!--Data Table-->
<script type="text/javascript"  src=" https://cdn.datatables.net/1.10.13/js/jquery.dataTables.min.js"></script>
<script type="text/javascript"  src=" https://cdn.datatables.net/buttons/1.2.4/js/dataTables.buttons.min.js"></script>

<!--Export table buttons-->
<script type="text/javascript"  src="https://cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js"></script>
<script type="text/javascript" src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.24/build/pdfmake.min.js" ></script>
<script type="text/javascript"  src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.24/build/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.2.4/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.2.1/js/buttons.print.min.js"></script>
<script>
    
    $('document').ready(function() {
        console.log('<?php echo e($modalid); ?>');
        if('<?php echo e($modalid); ?>'!=""){
            var modal = "#"+'<?php echo e($modalid); ?>';
            if(modal){
                $('#notif_message').css("display","block");
                $('#showme').css("display","none");
                $(modal).modal('show');
                modal="";
            }else{
                $('#notif_message').css("display","none");
                $('#showme').css("display","block");
                $(modal).modal('show');
            }
        }
        
    });
    function confirmDelete(id,name) {
        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you want to remove this service '+name+'?',
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: `Ok`,
            cancelButtonText: `Cancel`,
        }).then((result) => {
            if (result.isConfirmed) {
                $('#'+id).submit();
            } 
        })
    }
</script>
<script type="text/javascript">
    $(document).ready(function() {
        $.noConflict();
        
        // $('#DataTables').DataTable({
        //     "ordering": false,
        //     "info": true,
        //     "autoWidth": false,
        //     "bInfo": false,
        //     "paging": true,
        //     "lengthMenu": [[25, 50, -1], [25, 50, "All"]],
        //     "dom": "Bfrtip",
        //     "buttons": [
        //         {
        //         extend: "copy",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "csv",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "excel",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "print",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "pdf",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //     ],
        // }),
        // $(
        // ".buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel"
        // ).removeClass("dt-button buttons-html5").addClass("btn btn-info square  mr-1 mb-1");
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/codeat5/redington.codeatechnologies.com/resources/views/admin/business/requestlist.blade.php ENDPATH**/ ?>