<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.13/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.2.4/css/buttons.dataTables.min.css">
<link rel="stylesheet" href="http://bootstrap-tagsinput.github.io/bootstrap-tagsinput/dist/bootstrap-tagsinput.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/css/select2.min.css" />
<style>
    table { /* this somehow makes it work for td */
        table-layout:fixed;
        width:100%;
    }
    table.dataTable tbody td {
        word-break: break-word;
        vertical-align: top;
    }
.required:after {
        content: "*";
        color: red;
    }
    .error{
        color:red;
    }
    .bootstrap-tagsinput .tag {
        background: #3bafda;
        border: 1px solid #3bafda;
        padding: 0 6px;
        margin-right: 2px;
        color: white;
        border-radius: 4px;
    }
    .bootstrap-tagsinput {
        width: 100% !important;
        height: calc(2.75rem + 2px) !important;
    }
    .select2-container{
        display: inline !important;
    }
</style>
<div class="app-content content">
    <div class="content-wrapper">
        <br>
        <?php echo $__env->make('alert.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Latest Events</h4>
                        <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                        <div class="heading-elements">
                            <ul class="list-inline mb-0">
                                <li><a data-toggle="modal" data-target="#createEventModal"  href="#" class="btn btn-success mr-1 mb-1 ladda-button" data-style="expand-left"><i class="ft-plus white"></i> <span class="ladda-label">Add Event</span></a></li>
                                <li><a data-action="expand"><i class="ft-maximize"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-content collapse show">
                        <div class="card-body card-dashboard">
                            <ul class="list-inline">
                                <li class="pr-1"><a href="<?php echo e(url('admin/list/new/events')); ?>" class="list-group-item active">New Events</a></li>
                                <li class="pr-1"><a href="<?php echo e(url('admin/list/past/events')); ?>" class="list-group-item list-group-item-action">Past Events</a></li>
                            </ul>
                            <table class="table table-striped table-bordered dom-jQuery-events dataTable" id="DataTables" role="grid" aria-describedby="DataTables_Table_0_info">
                                <thead>
                                    <tr role="row">
                                        <th>Title</th>
                                        <th>Image</th>
                                        
                                        <th>Access By</th>
                                        <th>Date Time</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr role="row" class="odd">
                                        <td><?php echo e($event->title); ?></td>
                                        <td><img height="60" width="140" src="<?php echo e(url($event->image)); ?>"></td>
                                        
                                        <td>
                                            <ul class="list-inline mb-0">
                                                <?php $__empty_2 = true; $__currentLoopData = explode(',',$event->access); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                    <li> <?php if($type==2): ?> <p class="text-info">Customer</p> <?php elseif($type==3): ?> <p class="text-warning">Partner</p> <?php else: ?> Employee <?php endif; ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?> 
                                                <?php endif; ?>
                                            </ul>    
                                        </td>
                                        <td><?php echo e(Carbon\Carbon::parse($event->date_time)->format('j F Y h:i A')); ?></td>
                                        <td><h4 <?php if($event->status==1): ?> class="danger text-center" <?php else: ?> class="success text-center" <?php endif; ?>><?php echo e(($event->status==1)?"Inactive":"Active"); ?></h4></td>
                                        <td>
                                            <a class="btn btn-primary text-white tab-order" data-toggle="modal" data-target="#editEventModal<?php echo e($event->id); ?>"  href="#"><i class="icon-pencil"></i></a>
                                            <button <?php if($event->status==0): ?> class="btn btn-danger text-white tab-order" <?php else: ?> class="btn btn-success text-white tab-order" <?php endif; ?> onclick="confirmDelete('event-active-<?php echo e($event->id); ?>','<?php echo e($event->title); ?>','<?php echo e($event->status); ?>');"> <?php if($event->status==0): ?> <i class="fa fa-thumbs-o-down"></i> <?php else: ?> <i class="fa fa-thumbs-o-up"></i> <?php endif; ?></button>
                                            <form id="event-active-<?php echo e($event->id); ?>" action="<?php echo e(url('admin/active/event/')); ?>/<?php echo e($event->id); ?>" method="get">
                                                <?php echo e(csrf_field()); ?>

                                            </form>
                                        </td>
                                    </tr>
                                    <div class="modal fade text-left show" id="editEventModal<?php echo e($event->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel35" style="padding-right: 17px;">
                                        <div class="modal-dialog" role="document">
                                          <div class="modal-content">
                                            <div class="modal-header">
                                              <h3 class="modal-title" id="myModalLabel35"> Edit Event</h3>
                                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">×</span>
                                              </button>
                                            </div>
                                            <form method="POST" action="<?php echo e(url('admin/update/event')); ?>/<?php echo e($event->id); ?>" enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">
                                                    <fieldset class="form-group floating-label-form-group">
                                                        <label for="eventname" class="label-control required">Event Title</label>
                                                        <input type="text" class="form-control" id="eventname" name="eventname" placeholder="Event Title" value="<?php echo e($event->title); ?>">
                                                          <?php if($errors->has('eventname')): ?>
                                                              <span class="help-block">
                                                                  <strong class="error"><?php echo e($errors->first('eventname')); ?></strong>
                                                              </span>
                                                          <?php endif; ?>
                                                    </fieldset>
                                                    <br>
                                                    <fieldset class="form-group floating-label-form-group">
                                                        <label for="title1" class="label-control required">Event Short Description</label>
                                                        <textarea class="form-control detail1" id="eventshortdescription<?php echo e($event->id); ?>" name="eventshortdescription" placeholder="Event Short Description"><?php echo $event->short; ?></textarea>
                                                        <?php if($errors->has('eventshortdescription')): ?>
                                                            <span class="help-block">
                                                                <strong class="error"><?php echo e($errors->first('eventshortdescription')); ?></strong>
                                                            </span>
                                                        <?php endif; ?>
                                                    </fieldset>
                                                    <fieldset class="form-group floating-label-form-group">
                                                        <label for="title1" class="label-control required">Event Description</label>
                                                        <textarea class="form-control detail2" id="eventdescription<?php echo e($event->id); ?>" name="eventdescription" placeholder="Event Description"><?php echo $event->description; ?></textarea>
                                                          <?php if($errors->has('eventdescription')): ?>
                                                              <span class="help-block">
                                                                  <strong class="error"><?php echo e($errors->first('eventdescription')); ?></strong>
                                                              </span>
                                                          <?php endif; ?>
                                                    </fieldset>
                                                    <fieldset class="form-group floating-label-form-group">
                                                        <label for="type" class="label-control required">Access By</label>
                                                        <select name="type[]" id="type11" class="form-control select2-multi" multiple>
                                                              <option value="">Select any type</option>
                                                              <option value="2" <?php if(in_array(2,explode(',',$event->access))): ?> selected <?php else: ?> <?php endif; ?>>Customer</option>
                                                              <option value="3" <?php if(in_array(3,explode(',',$event->access))): ?> selected <?php else: ?> <?php endif; ?>>Partner</option>
                                                              
                                                        </select>
                                                          <?php if($errors->has('type')): ?>
                                                              <span class="help-block">
                                                                  <strong class="error"><?php echo e($errors->first('type')); ?></strong>
                                                              </span>
                                                          <?php endif; ?>
                                                    </fieldset>
                                                      <fieldset class="form-group floating-label-form-group">
                                                        <img class="card-img-top img-fluid" src="<?php echo e(url($event->image)); ?>" alt="<?php echo e($event->title); ?>">
                                                          <label for="file" class="label-control required">Image</label>
                                                          <input type="file" class="form-control" id="file" name="image" placeholder="files">
                                                          <?php if($errors->has('image')): ?>
                                                              <span class="help-block">
                                                                  <strong class="error"><?php echo e($errors->first('image')); ?></strong>
                                                              </span>
                                                          <?php endif; ?>
                                                      </fieldset>
                                                      
                                                      <fieldset class="form-group floating-label-form-group">
                                                          <label for="email" class="label-control required">Date</label>
                                                          <input type="date" class="form-control" id="date" name="date1" min="<?php echo date("Y-m-d"); ?>" value="<?php echo date('Y-m-d',strtotime($event->date_time)) ?>">
                                                            <?php if($errors->has('date')): ?>
                                                                <span class="help-block">
                                                                    <strong class="error"><?php echo e($errors->first('date')); ?></strong>
                                                                </span>
                                                            <?php endif; ?>
                                                        </fieldset>
                                                        <br>
                                                      <fieldset class="form-group floating-label-form-group">
                                                          <label for="title1" class="label-control required">Time</label>
                                                          <input class="form-control" type="time" name="time" id="time" value="<?php echo e(Carbon\Carbon::parse($event->date_time)->format('h:i')); ?>">
                                                            <?php if($errors->has('time')): ?>
                                                                <span class="help-block">
                                                                    <strong class="error"><?php echo e($errors->first('time')); ?></strong>
                                                                </span>
                                                            <?php endif; ?>
                                                      </fieldset>
                                                </div>
                                              <div class="modal-footer">
                                                  <input type="reset" class="btn btn-outline-secondary btn-lg" data-dismiss="modal" value="close">
                                                  <input type="submit" class="btn btn-outline-primary btn-lg" value="Update">
                                              </div>
                                            </form>
                                          </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <div class="pull-right">
                                <?php echo $events->render(); ?>

                            </div>
                        </div>
                    </div>
                    <div class="modal fade text-left show" id="createEventModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel35" style="padding-right: 17px;">
                        <div class="modal-dialog" role="document">
                          <div class="modal-content">
                            <div class="modal-header">
                              <h3 class="modal-title" id="myModalLabel35"> Create Event</h3>
                              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                              </button>
                            </div>
                            <form method="POST" action="<?php echo e(url('admin/add/new/event')); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                              <div class="modal-body">
                                  <fieldset class="form-group floating-label-form-group">
                                      <label for="eventname" class="label-control required">Event Title</label>
                                      <input type="text" class="form-control" id="eventname" name="eventname" placeholder="Event Title">
                                        <?php if($errors->has('eventname')): ?>
                                            <span class="help-block">
                                                <strong class="error"><?php echo e($errors->first('eventname')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                  </fieldset>
                                  <br>
                                  <fieldset class="form-group floating-label-form-group">
                                        <label for="title1" class="label-control required">Event Short Description</label>
                                        <textarea class="form-control" id="eventshortdescription" name="eventshortdescription" placeholder="Event Short Description"></textarea>
                                        <?php if($errors->has('eventshortdescription')): ?>
                                            <span class="help-block">
                                                <strong class="error"><?php echo e($errors->first('eventshortdescription')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </fieldset>
                                  <fieldset class="form-group floating-label-form-group">
                                      <label for="title1" class="label-control required">Event Main Description</label>
                                      <textarea class="form-control" id="eventdescription" name="eventdescription" placeholder="Event Description"></textarea>
                                        <?php if($errors->has('eventdescription')): ?>
                                            <span class="help-block">
                                                <strong class="error"><?php echo e($errors->first('eventdescription')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                  </fieldset>
                                  <br>
                                  
                                  <fieldset class="form-group floating-label-form-group">
                                    <label for="type" class="label-control required">Access By</label>
                                    <select name="type[]" id="type1" class="form-control select2-multi" multiple>
                                          <option value="">Select any type</option>
                                          <option value="2">Customer</option>
                                          <option value="3">Partner</option>
                                          
                                    </select>
                                      <?php if($errors->has('type')): ?>
                                          <span class="help-block">
                                              <strong class="error"><?php echo e($errors->first('type')); ?></strong>
                                          </span>
                                      <?php endif; ?>
                                  </fieldset>
                                    <fieldset class="form-group floating-label-form-group">
                                        <label for="file" class="label-control required">Image</label>
                                        <input type="file" class="form-control" id="file" name="image" placeholder="files">
                                        <?php if($errors->has('image')): ?>
                                            <span class="help-block">
                                                <strong class="error"><?php echo e($errors->first('image')); ?></strong>
                                            </span>
                                        <?php endif; ?>
                                    </fieldset>
                                    
                                    <fieldset class="form-group floating-label-form-group">
                                        <label for="email" class="label-control required">Date</label>
                                        <input type="date" class="form-control" id="date" name="date" min="<?php echo date("Y-m-d"); ?>">
                                          <?php if($errors->has('date')): ?>
                                              <span class="help-block">
                                                  <strong class="error"><?php echo e($errors->first('date')); ?></strong>
                                              </span>
                                          <?php endif; ?>
                                      </fieldset>
                                      <br>
                                    <fieldset class="form-group floating-label-form-group">
                                        <label for="title1" class="label-control required">Time</label>
                                        <input class="form-control" type="time" name="time" id="time" value="08:00">
                                          <?php if($errors->has('time')): ?>
                                              <span class="help-block">
                                                  <strong class="error"><?php echo e($errors->first('time')); ?></strong>
                                              </span>
                                          <?php endif; ?>
                                    </fieldset>
                              </div>
                              <div class="modal-footer">
                                  <input type="reset" class="btn btn-outline-secondary btn-lg" data-dismiss="modal" value="close">
                                  <input type="submit" class="btn btn-outline-primary btn-lg" value="Save">
                              </div>
                            </form>
                          </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Import jQuery before export.js-->
<script type="text/javascript" src="https://code.jquery.com/jquery-2.1.1.min.js"></script>
<script src="https://cdn.ckeditor.com/4.14.0/standard-all/ckeditor.js"></script>

<!--Data Table-->
<script type="text/javascript"  src=" https://cdn.datatables.net/1.10.13/js/jquery.dataTables.min.js"></script>
<script type="text/javascript"  src=" https://cdn.datatables.net/buttons/1.2.4/js/dataTables.buttons.min.js"></script>

<!--Export table buttons-->
<script type="text/javascript"  src="https://cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js"></script>
<script type="text/javascript" src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.24/build/pdfmake.min.js" ></script>
<script type="text/javascript"  src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.24/build/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.2.4/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.2.1/js/buttons.print.min.js"></script>
<script src="https://cdn.jsdelivr.net/bootstrap.tagsinput/0.8.0/bootstrap-tagsinput.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.5/js/select2.min.js"></script>
<script>
    $('.select2-multi').select2();
    CKEDITOR.replace( 'eventdescription' );
    CKEDITOR.replace( 'eventshortdescription' );
    // CKEDITOR.replace( 'detail2' );

    $('.detail1').each(function () {
        CKEDITOR.replace($(this).prop('id'));
    });
    $('.detail2').each(function () {
        CKEDITOR.replace($(this).prop('id'));
    });
</script>
<script>
    // var today = new Date().toISOString().split('T')[0];
    // document.getElementsByName("date")[0].setAttribute('min', today);
    // document.getElementsByName("date1")[0].setAttribute('min', today);
    function confirmDelete(id,name) {
        if(status==0){
            var text="inactive";
        }else{
            var text="active";
        }
        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you want to '+text+' the '+name+'?',
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: `Ok`,
            cancelButtonText: `Cancel`,
        }).then((result) => {
            if (result.isConfirmed) {
                $('#'+id).submit();
            } 
        })
    }
</script>
<script type="text/javascript">
    $(document).ready(function() {
        $.noConflict();
        
        // $('#DataTables').DataTable({
        //     "ordering": false,
        //     "info": true,
        //     "autoWidth": false,
        //     "bInfo": false,
        //     "paging": true,
        //     "lengthMenu": [[25, 50, -1], [25, 50, "All"]],
        //     "dom": "Bfrtip",
        //     "buttons": [
        //         {
        //         extend: "copy",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "csv",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "excel",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "print",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //         {
        //         extend: "pdf",
        //         exportOptions: { columns: [":visible :not(:last-child)"] },
        //         },
        //     ],
        // }),
        // $(
        // ".buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel"
        // ).removeClass("dt-button buttons-html5").addClass("btn btn-info square  mr-1 mb-1");
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.adminlay', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/codeat5/redington.codeatechnologies.com/resources/views/admin/events/new.blade.php ENDPATH**/ ?>